﻿using System;
using System.Threading.Tasks;
using MyFirstApp.Client.Services;
using MyFirstApp.Shared;
using Syncfusion.Blazor.Buttons;
using Syncfusion.Blazor.Popups;

namespace MyFirstApp.Client.ViewModels
{
    public class UserFormViewModel
    {
        private readonly UserService _userService;
        public bool ShowButton { get; set; } = false;
        public bool Visibility { get; set; } = false;
        SfCheckBox<bool> CheckboxObj;


        public UserFormViewModel(UserService userService)
        {
            _userService = userService;
        }

        public async Task Update(User user)
        {
            await _userService.Update(user);            
        }

        public void DialogOpen(Object args)
        {
            this.ShowButton = false;
        }

        public void DialogClose(Object args)
        {
            this.ShowButton = true;
        }

        public void OnBtnClick()
        {
            this.Visibility = true;
        }

        public void ShowDialog()
        {
            this.Visibility = true;
        }

        public void DlgCancelButtonClick()
        {
            this.Visibility = false;
        }

        public void OverlayClick(OverlayModalClickEventArgs args)
        {
            if ((bool)this.CheckboxObj.Checked)
            {
                this.Visibility = false;
            }
            else
            {
                this.Visibility = true;
            }
        }
    }
}
